package jp.mosp.common.part;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.payroll.dao.MKintaiKeisanDao;
import jp.mosp.payroll.dto.MKintaiKeisanDto;

/**
 * ΑӌvZɊւPartNX
 * @author yoshida
 *	@version	0.0.2
 */
public class CalculatePart extends BasePart {

	/**
	 * RXgN^
	 */
	public CalculatePart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public CalculatePart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * M_KINTAIKEISANe[upDAO擾
	 * @return	ςMKintaiKeisanDaoCX^X
	 * @throws Exception
	 */
	public MKintaiKeisanDao getKeisanDao() throws Exception {
		return (MKintaiKeisanDao)getPreparedDao(MKintaiKeisanDao.class.getCanonicalName());
	}

	/**
	 * @return
	 * @throws Exception
	 */
	public MKintaiKeisanDto findForCalc() throws Exception {
		return getKeisanDao().findForCalc();
	}

	/**
	 * ΑӒ擾
	 * @return	Date	Ώ۔N
	 * @throws MospException 
	 * @throws ClassNotFoundException 
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws Exception
	 */
	public Date getCalcMonth() throws Exception {
		MKintaiKeisanDto dto = findForCalc();
		// Ώ۔Nl擾
		Date targetDate = DatePart.getSystemDate();
		if (dto != null) {
			int closeDay = Integer.parseInt(mospcode().getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS)[2]);
			if (closeDay == 0) {
				closeDay = 1;
			}
			targetDate = DatePart.getDate(dto.getKTNen(), dto.getKTTuki(), closeDay);
		}
		return targetDate;
	}

	/**
	 * ΑӌvZ擾
	 * @return yyyymm vZN
	 * @throws Exception
	 */
	public Date getCalcAttendance() throws Exception {
		// Ώ۔N擾
		Date targetDate = getCalcMonth();
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetDate);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		// ߓ擾
		int minusMonth = Integer.parseInt(mospcode().getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_MONTH)[2]);
		int closeDay   = Integer.parseInt(mospcode().getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS)[2]);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.roll(Calendar.MONTH, minusMonth * -1);
		if (closeDay != 0) {
			cal.roll(Calendar.MONTH, 1);
			cal.set(Calendar.DAY_OF_MONTH, closeDay);
		}
		return cal.getTime();
	}

	/**
	 * ^xΏ۔N擾
	 * @param targetDate Ώۓ
	 * @return	iΑӏWvji^xj
	 * @throws Exception
	 */
	public Date getCalcPayment(Date targetDate) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetDate);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		// x擾
		int plusMonth	= Integer.parseInt(mospcode().getMosPCode(CommonConst.TID_PROVIDED_DATE, CommonConst.TCD_MONTH)[2]);
		int providedDay	= Integer.parseInt(mospcode().getMosPCode(CommonConst.TID_PROVIDED_DATE, CommonConst.TCD_DAYS)[2]);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.roll(Calendar.MONTH, plusMonth * 1);
		// 1̏ꍇAxɂėN擾
		if ((cal.get(Calendar.MONTH) == 0)	&& plusMonth != 0) {
			cal.roll(Calendar.YEAR, 1);
		}
		if (providedDay != 0) {
			cal.set(Calendar.DAY_OF_MONTH, providedDay);
		}
		return cal.getTime();
	}

	/**
	 * ^x擾
	 * @return	Date	Ώ۔N
	 * @throws Exception
	 */
	public Date getCalcPayment() throws Exception {
		MKintaiKeisanDto dto = findForCalc();
		// Ώ۔Nl擾
		Date targetDate = getCalcPayment(DatePart.getSystemDate());
		if (VariousPart.chkExistDto(dto)) {
			targetDate = DatePart.getDate(dto.getKSNen(), dto.getKSTuki(), dto.getKShi());
		}
		return targetDate;
	}

	/**
	 * WvJn擾
	 * @param targetMonth Ώی
	 * @return WvJn
	 * @throws Exception
	 */
	public Date getStartDate(Date targetMonth) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetMonth);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		// ߓ擾
		int minusMonth = Integer.parseInt(mospcode().getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_MONTH)[2]);
		int closeDay   = Integer.parseInt(mospcode().getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS)[2]);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		cal.add(Calendar.MONTH, minusMonth * -1);
		// WvJnvZ
		if (closeDay != 0) {
			if (MospUtility.getDay(targetMonth) <= closeDay) {
				cal.add(Calendar.MONTH, -1);
			}
			cal.set(Calendar.DAY_OF_MONTH, closeDay);
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		return cal.getTime();
	}

	/**
	 * WvI擾
	 * @param targetMonth Ώی
	 * @return WvI
	 * @throws Exception
	 */
	public Date getEndDate(Date targetMonth) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		// ߓ擾
		int closeDay   = Integer.parseInt(mospcode().getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS)[2]);
		// Jn擾
		cal.setTime(getStartDate(targetMonth));
		// ꃖZ
		cal.add(Calendar.MONTH, 1);
		if (closeDay != 0) {
			// w
			cal.roll(Calendar.DAY_OF_MONTH, -1);
		} else {
			// 
			cal.add(Calendar.MONTH, -1);
			// Ώی̍ŏIZbg
			cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
		}
		return cal.getTime();
	}

	/**
	 * Wv擾
	 * @param targetDate Ώۓ
	 * @return Wv
	 * @throws Exception
	 */
	public Date getCurrentDate(Date targetDate) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetDate);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		// ߓ擾
		int minusMonth = Integer.parseInt(mospcode().getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_MONTH)[2]);
		int closeDay   = Integer.parseInt(mospcode().getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS)[2]);
		// Wv擾
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.roll(Calendar.MONTH, minusMonth * -1);
		if (closeDay != 0) {
			if (MospUtility.getDay(targetDate) > closeDay) {
				cal.roll(Calendar.MONTH, 1);
			}
		}
		return cal.getTime();
	}

	/**
	 * \pJnN
	 * <p>2009/01/20	m.yoshida	ǉ</p>
	 * @param targetDate	Ώ۔N	
	 * @return \pJnN
	 * @throws Exception
	 */
	public Date getStartDateForList(Date targetDate) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetDate);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		// ߓ擾
		int closeDay   = Integer.parseInt(mospcode().getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS)[2]);
		// WvJnvZ
		if (closeDay != 0) {
			if (MospUtility.getDay(targetDate) <= closeDay) {
				cal.add(Calendar.MONTH, -1);
			}
			cal.set(Calendar.DAY_OF_MONTH, closeDay);
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		return cal.getTime();
	}

	/**
	 * \pIN
	 * <p>2009/01/20	m.yoshida	ǉ</p>
	 * @param targetDate	Ώ۔N
	 * @return \pJnN
	 * @throws Exception
	 */
	public Date getEndDateForList(Date targetDate) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		// ߓ擾
		int closeDay   = Integer.parseInt(mospcode().getMosPCode(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS)[2]);
		// Jn擾
		cal.setTime(getStartDateForList(targetDate));
		// ꃖZ
		cal.add(Calendar.MONTH, 1);
		if (closeDay != 0) {
			// w
			cal.roll(Calendar.DAY_OF_MONTH, -1);
		} else {
			// 
			cal.add(Calendar.MONTH, -1);
			// Ώی̍ŏIZbg
			cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
		}
		return cal.getTime();
	}


	/**
	 * ΑӌvZIf
	 * @since	0.0.2
	 * @return
	 * <p>
	 * ΑӌvZĂꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	public boolean isCalculateFinish() throws Exception {
		return isCalculateFinish(findForCalc());
	}

	/**
	 * ΑӌvZIf
	 * @since	0.0.2
	 * @param dto	ΏDTO
	 * @return
	 * <p>
	 * ΑӌvZĂꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	public static boolean isCalculateFinish(MKintaiKeisanDto dto) throws Exception {
		if (VariousPart.chkExistDto(dto) 
				&& CommonConst.NUM_ATTENDANCE_CALCULATE_FLAG_ON.equals(dto.getKKanryou())
		) {
			return true;
		}
		return false;
	}

	/**
	 * Ώ۔NΑӒߓf
	 * @since	0.0.2
	 * @param targetDate		Ώ۔N
	 * @return
	 * <p>
	 * Ώ۔NΑӒߓOȂtrueAłȂꍇfalse
	 * <p>
	 * @throws Exception
	 */
	public boolean isBeforeCalcMonth(Date targetDate) throws Exception {
		// ΑӒߓ
		Date calcMonth = getCalcMonth();
		// ΑӌvZI͗
		if (isCalculateFinish()) {
			calcMonth = DatePart.addMonth(calcMonth, 1);
		}
		// ΑӏWvȌꍇ
		if (calcMonth.compareTo(targetDate) > 0) {
			return true;
		}
		return false;
	}

}
